#include <Arduino.h>
#define BARPORT 0x00

class LEDBAR
{
private:
  unsigned int Clk; 
  unsigned int Data; 
  bool PORT;        
  unsigned char state[10];

  void SEND(unsigned int da); 
  void LATCH(void);              
  void SET(unsigned char bits[]);

public:
  LEDBAR(unsigned char PINClk, unsigned char PINData, bool PT); 
  void Mode(){
    pinMode(Clk, OUTPUT); 
    pinMode(Data, OUTPUT);
    }
  void FLOOR(float level);                     
  void Toggle(unsigned char led);               
  void OUT(unsigned int bits);              
  unsigned int const Getbits();
};

LEDBAR::LEDBAR(unsigned char PINClk, unsigned char PINData, bool PT)
{
  Clk = PINClk;
  Data = PINData;
  PORT = PT;

  for (byte i = 0; i < 10; i++)
    state[i] = 0x00; 

  pinMode(Clk, OUTPUT);
  pinMode(Data, OUTPUT);
}

void LEDBAR::LATCH()
{
  digitalWrite(Data, LOW);
  delayMicroseconds(10);

  for (unsigned char i = 0; i < 4; i++)
  {
    digitalWrite(Data, HIGH);
    digitalWrite(Data, LOW);
  }
}

void LEDBAR::SEND(unsigned int da)
{
  for (unsigned char i = 0; i < 16; i++)
  {
    unsigned int state = (da & 0x8000) ? HIGH : LOW;
    digitalWrite(Data, state);

    state = digitalRead(Clk) ? LOW : HIGH;
    digitalWrite(Clk, state);

    da <<= 1;
  }
}

void LEDBAR::FLOOR(float level)
{
  level = max(0, min(10, level));
  level *= 8; // there are 8 (noticable) levels of brightness on each segment
  
  // Place number of 'level' of 1-bits on state
  for (byte i = 0; i < 10; i++) {
    state[i] = (level > 8) ? ~0 :
                 (level > 0) ? ~(~0 << byte(level)) : 0;
               
    level -= 8;
  };

  SET(state);
}

void LEDBAR::Toggle(unsigned char led)
{
  led = max(1, min(10, led));

  // Zero based index 0-9 for bitwise operations
  led--;

  state[led] = state[led] ? 0 : ~0;

  SET(state);
}

void LEDBAR::SET(unsigned char state[])
{

  SEND(BARPORT);

  for (unsigned char i = 0; i < 10; i++)
  {
    if (PORT)
    {
    // Go backward on state
      SEND(state[10-i-1]);
    }
    else
    {
    // Go forward on state
      SEND(state[i]);
    }
  }
  SEND(0x00);
  SEND(0x00);

  LATCH();
}

void LEDBAR::OUT(unsigned int bits)
{

  for (unsigned char i = 0; i < 10; i++)
  {

    if ((bits % 2) == 1)
      state[i] = 0xFF;
    else
      state[i] = 0x00;
    bits /= 2;
  }

  SET(state);
}

unsigned int const LEDBAR::Getbits()
{
  unsigned int __bits = 0x00;
  for (unsigned char i = 0; i < 10; i++)
  {
    if (state[i] != 0x0)
        __bits |= (0x1 << i);
  }
  return __bits;
}
LEDBAR bar(7, 6, 0);  

void setup()
{
  // nothing to initialize
  bar.Mode();
}

void loop()
{

  bar.OUT(0b000001111111111);
  delay(1000);

  bar.OUT(0b000000000000000);
  delay(1000);

  bar.OUT(0b000000000000001);
  delay(1000);

  bar.OUT(0b000000000000101);
  delay(1000);

  bar.OUT(0b000000000010101);
  delay(1000);

  bar.OUT(0b000000001010101);
  delay(1000);

  bar.OUT(0b000000101010101);
  delay(1000);

  bar.OUT(0b000001010101010);
  delay(1000);

  bar.OUT(0b000000101010101);
  delay(1000);

  bar.OUT(0b000001010101010);
  delay(1000);

  bar.OUT(0b000000101010101);
  delay(1000);
  
  bar.OUT(0b000000000011111);
  delay(1000);

  bar.OUT(0b000001111100000);
  delay(1000);

}
